<?php
// /public_html/api/assets/list.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('GET');

$active = isset($_GET['active']) ? (int)$_GET['active'] : 1;
$category = trim((string)($_GET['category'] ?? ''));
$q = trim((string)($_GET['q'] ?? ''));

$where = [];
$params = [];
$types = '';

if ($active === 1) { $where[] = "is_active = 1"; }
elseif ($active === 0) { $where[] = "is_active = 0"; } // allow listing inactive

if ($category !== '') {
  $where[] = "category = ?";
  $types .= 's';
  $params[] = $category;
}

$sql = "SELECT id, name, category, tags, file_path, width_mm, height_mm, mime_type, is_active, created_at, updated_at FROM assets";
if (!empty($where)) $sql .= " WHERE " . implode(' AND ', $where);

if ($q !== '') {
  // If FULLTEXT exists, prefer it; fallback to LIKE.
  // We'll do LIKE for simplicity & compatibility.
  $sql .= (empty($where) ? " WHERE " : " AND ") . "(name LIKE ? OR category LIKE ? OR tags LIKE ?)";
  $types .= 'sss';
  $like = '%' . $q . '%';
  $params[] = $like; $params[] = $like; $params[] = $like;
}

$sql .= " ORDER BY category ASC, name ASC";

$stmt = $con->prepare($sql);
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

if ($types !== '') {
  $bind = [];
  $bind[] = $types;
  foreach ($params as $k => $v) $bind[] = &$params[$k];
  call_user_func_array([$stmt, 'bind_param'], $bind);
}

$stmt->execute();
$res = $stmt->get_result();

$assets = [];
while ($res && ($r = $res->fetch_assoc())) {
  $r['id'] = (int)$r['id'];
  $r['is_active'] = (int)$r['is_active'];
  $assets[] = $r;
}
$stmt->close();

json_out(['success' => true, 'assets' => $assets]);