<?php
// /public_html/api/assets/update.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');
$body = read_json_body();

$id = (int)($body['id'] ?? 0);
if ($id <= 0) json_out(['success' => false, 'message' => 'Missing id.'], 400);

$name = trim((string)($body['name'] ?? ''));
$category = trim((string)($body['category'] ?? ''));
$tags = trim((string)($body['tags'] ?? ''));

$width_mm  = $body['width_mm'] ?? null;
$height_mm = $body['height_mm'] ?? null;

$width_mm = $width_mm !== null ? clamp_dec($width_mm, 0.001, 100000, 0) : null;
$height_mm = $height_mm !== null ? clamp_dec($height_mm, 0.001, 100000, 0) : null;

$sets = [];
$params = [];
$types = '';

if ($name !== '') { $sets[] = "name=?"; $types.='s'; $params[]=$name; }
if ($category !== '') { $sets[] = "category=?"; $types.='s'; $params[]=$category; }
$sets[] = "tags=?"; $types.='s'; $params[]=$tags; // allow clearing tags

if ($width_mm !== null) { if ($width_mm<=0) json_out(['success'=>false,'message'=>'Invalid width_mm.'],400); $sets[]="width_mm=?"; $types.='d'; $params[]=$width_mm; }
if ($height_mm !== null) { if ($height_mm<=0) json_out(['success'=>false,'message'=>'Invalid height_mm.'],400); $sets[]="height_mm=?"; $types.='d'; $params[]=$height_mm; }

if (empty($sets)) json_out(['success' => false, 'message' => 'Nothing to update.'], 400);

$sql = "UPDATE assets SET " . implode(', ', $sets) . " WHERE id=?";
$types .= 'i';
$params[] = $id;

$stmt = $con->prepare($sql);
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$bind = [];
$bind[] = $types;
foreach ($params as $k => $v) $bind[] = &$params[$k];
call_user_func_array([$stmt, 'bind_param'], $bind);

$stmt->execute();
$affected = $stmt->affected_rows;
$stmt->close();

json_out(['success' => true, 'affected' => $affected]);