<?php
// /public_html/api/background/save_calibration.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');
$body = read_json_body();

$token = (string)($body['token'] ?? '');
$background_id = (int)($body['background_id'] ?? 0);
if ($background_id <= 0) json_out(['success' => false, 'message' => 'Missing background_id.'], 400);

$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

$px_per_mm = $body['px_per_mm'] ?? null;
$px_per_mm = clamp_dec($px_per_mm, 0.000001, 1000000, 0);
if ($px_per_mm <= 0) json_out(['success' => false, 'message' => 'Invalid px_per_mm.'], 400);

$cal = $body['calibration'] ?? null;
$cal_json = null;
if (is_array($cal)) {
  $cal_json = json_encode($cal, JSON_UNESCAPED_SLASHES);
  if ($cal_json === false) $cal_json = null;
}

$stmt = $con->prepare("
  UPDATE project_backgrounds
  SET px_per_mm = ?, calibration_json = ?
  WHERE id = ? AND project_id = ?
");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$stmt->bind_param('dsii', $px_per_mm, $cal_json, $background_id, $project_id);
$stmt->execute();
$affected = $stmt->affected_rows;
$stmt->close();

if ($affected <= 0) json_out(['success' => false, 'message' => 'Background not found for project (or no changes).'], 404);

json_out(['success' => true, 'px_per_mm' => $px_per_mm]);