<?php
// /public_html/api/background/save_corrected.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');

$token = (string)($_POST['token'] ?? '');
$background_id = (int)($_POST['background_id'] ?? 0);
$corner_points_json = (string)($_POST['corner_points_json'] ?? '');

if ($background_id <= 0) json_out(['success' => false, 'message' => 'Missing background_id.'], 400);

$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

if (!isset($_FILES['file'])) json_out(['success' => false, 'message' => 'Missing file.'], 400);

$allowed = ['image/png','image/jpeg','image/webp']; // corrected can be png/jpg/webp
$origName = safe_filename((string)($_FILES['file']['name'] ?? 'corrected'));
$ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
if (!in_array($ext, ['png','jpg','jpeg','webp'], true)) $ext = 'png';
if ($ext === 'jpeg') $ext = 'jpg';

$bgDirAbs = UPLOAD_ROOT . "/projects/{$project_id}/background";
ensure_dir($bgDirAbs);

$destAbs = $bgDirAbs . "/corrected." . $ext;
$move = move_uploaded_file_validated($_FILES['file'], $allowed, $destAbs);
if (!$move['ok']) json_out(['success' => false, 'message' => $move['message'] ?? 'Upload failed.'], 400);

$corrected_path = URL_UPLOADS_PREFIX . "/projects/{$project_id}/background/corrected." . $ext;

// Validate corner JSON (best-effort)
$corner_json_db = null;
if (trim($corner_points_json) !== '') {
  $tmp = json_decode($corner_points_json, true);
  if (is_array($tmp)) $corner_json_db = json_encode($tmp, JSON_UNESCAPED_SLASHES);
}

// Update row (ensure background belongs to this project)
$stmt = $con->prepare("
  UPDATE project_backgrounds
  SET corrected_path = ?, corner_points_json = ?, mode = 'perspective'
  WHERE id = ? AND project_id = ?
");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$stmt->bind_param('ssii', $corrected_path, $corner_json_db, $background_id, $project_id);
$stmt->execute();
$affected = $stmt->affected_rows;
$stmt->close();

if ($affected <= 0) {
  json_out(['success' => false, 'message' => 'Background not found for project (or no changes).'], 404);
}

json_out([
  'success' => true,
  'corrected_path' => $corrected_path
]);