<?php
// /public_html/api/export/bom.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('GET');

$token = (string)($_GET['token'] ?? '');
$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

$stmt = $con->prepare("
  SELECT
    a.id AS asset_id,
    a.name,
    a.category,
    a.file_path,
    a.width_mm,
    a.height_mm,
    COUNT(*) AS qty
  FROM project_items pi
  JOIN assets a ON a.id = pi.asset_id
  WHERE pi.project_id = ?
  GROUP BY a.id, a.name, a.category, a.file_path, a.width_mm, a.height_mm
  ORDER BY a.category ASC, a.name ASC
");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$stmt->bind_param('i', $project_id);
$stmt->execute();
$res = $stmt->get_result();

$bom = [];
while ($res && ($r = $res->fetch_assoc())) {
  $r['asset_id'] = (int)$r['asset_id'];
  $r['qty'] = (int)$r['qty'];
  $bom[] = $r;
}
$stmt->close();

json_out(['success' => true, 'bom' => $bom]);