<?php
// /public_html/api/projects/create.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');
$body = read_json_body();

$name  = str_or((string)($body['name'] ?? ''), 'Untitled');
$notes = (string)($body['notes'] ?? '');

$token = uuid_v4();

$stmt = $con->prepare("INSERT INTO projects (project_token, name, notes) VALUES (?, ?, ?)");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);
$stmt->bind_param('sss', $token, $name, $notes);
$ok = $stmt->execute();
$pid = $ok ? (int)$stmt->insert_id : 0;
$stmt->close();

if (!$ok || $pid <= 0) json_out(['success' => false, 'message' => 'Failed to create project.'], 500);

json_out([
  'success' => true,
  'project_id' => $pid,
  'project_token' => $token
]);