<?php
// /public_html/api/projects/get.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('GET');

$token = (string)($_GET['token'] ?? '');
$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

// Latest background (if any)
$bg = null;
$stmt = $con->prepare("
  SELECT *
  FROM project_backgrounds
  WHERE project_id = ?
  ORDER BY id DESC
  LIMIT 1
");
if ($stmt) {
  $stmt->bind_param('i', $project_id);
  $stmt->execute();
  $res = $stmt->get_result();
  $bg = $res ? $res->fetch_assoc() : null;
  $stmt->close();
}
if ($bg) {
  $bg['id'] = (int)$bg['id'];
  $bg['project_id'] = (int)$bg['project_id'];
  $bg['width_px'] = $bg['width_px'] !== null ? (int)$bg['width_px'] : null;
  $bg['height_px'] = $bg['height_px'] !== null ? (int)$bg['height_px'] : null;
}

// Items
$items = [];
$stmt = $con->prepare("
  SELECT id, asset_id, x_px, y_px, rotation_deg, z_index, locked, meta_json
  FROM project_items
  WHERE project_id = ?
  ORDER BY z_index ASC, id ASC
");
if ($stmt) {
  $stmt->bind_param('i', $project_id);
  $stmt->execute();
  $res = $stmt->get_result();
  while ($res && ($r = $res->fetch_assoc())) {
    $r['id'] = (int)$r['id'];
    $r['asset_id'] = (int)$r['asset_id'];
    $r['z_index'] = (int)$r['z_index'];
    $r['locked'] = (int)$r['locked'];
    $items[] = $r;
  }
  $stmt->close();
}

json_out([
  'success' => true,
  'project' => $project,
  'background' => $bg,
  'items' => $items
]);